﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.IO;
using TMPro;
using UnityEngine;
using UnityEngine.PlayerLoop;
using UnityStandardAssets.Vehicles.Car;

public struct CarPosInfo
{
    public Vector3 Pos;
    public Quaternion Rot;
}

public class RacingGameManager : MonoBehaviour
{
    public bool RoadLoaded = false;
    public bool RaceStarted = false;
    public int MaxRoundCount = 2;
    [SerializeField]
    private TMP_Text countdownDisplay;
    public MyCar PlayerCar;
    private int countdownTime;
    [SerializeField]

    private int DisplayRoundCount = 0;
    public TMP_Text timeCounter;

    public TMP_Text PosDisplay;

    private TimeSpan timePlaying;
    private bool timerGoing;

    private float elapsedTime;

    public List<MyCar> Cars = new List<MyCar>();
    public static void LoadRoad(string fileName, List<CarPosInfo> list)
    {
        var RoadFile = new System.IO.FileStream(fileName, FileMode.Open);
        var br = new BinaryReader(RoadFile);
        list.Clear();
        while (RoadFile.Position < RoadFile.Length)
        {
            CarPosInfo posInfo = new CarPosInfo();
            posInfo.Pos.x = br.ReadSingle();
            posInfo.Pos.y = br.ReadSingle();
            posInfo.Pos.z = br.ReadSingle();

            posInfo.Rot.x = br.ReadSingle();
            posInfo.Rot.y = br.ReadSingle();
            posInfo.Rot.z = br.ReadSingle();
            posInfo.Rot.w = br.ReadSingle();

            list.Add(posInfo);
        }
        br.Close();
        br.Dispose();
        RoadFile.Dispose();
    }

    public List<CarPosInfo> Road = new List<CarPosInfo>();
    public void LoadRoad()
    {
        if (!RoadLoaded)
            LoadRoad(@"Assets/Road.dat", Road);
    }

    public void Start()
    {
        LoadRoad();
        timeCounter.text = "00:00.00";
        timerGoing = false;
        elapsedTime = 0;
        countdownTime = 3;
        countdownDisplay.gameObject.SetActive(true);
        StartCoroutine(CountdownToStart());
    }

    // Update is called once per frame
    int Comparison(MyCar x, MyCar y)
    {
        var c1 = x.RoundDone();
        var c2 = y.RoundDone();
        if (c1 < c2)
            return +1;
        if (c1 > c2)
            return -1;
        if (x.IntRoundDone < MaxRoundCount)
            return 0;
        if (x.time == y.time)
            return 0;
        if (x.time > y.time)
            return +1;
        else
            return -1;
    }

    void SortCars()
    {
        Cars.Sort(Comparison);
    }

    void Update()
    {
        SortCars();
        string s = "";
        for (int i = 0; i < Cars.Count; i++)
        {
            s += Cars[i].name + ": " + Cars[i].RoundDone() + "   ";
            if (Cars[i] == PlayerCar)
                PosDisplay.text = "Pos " + (i + 1) + "/" + Cars.Count; 

        }

        Debug.Log(s);

        if (PlayerCar != null && DisplayRoundCount < PlayerCar.IntRoundDone)
        {
            DisplayRoundCount = PlayerCar.IntRoundDone;
            if (DisplayRoundCount == MaxRoundCount)
            {
                countdownDisplay.fontSize = 400;
                countdownDisplay.text = "End";
                timerGoing = false;
            }
            else
            {
                countdownDisplay.fontSize = 150;
                countdownDisplay.text = "Round " + (DisplayRoundCount + 1);
                StartCoroutine(CountdownToHide());
            }
            countdownDisplay.gameObject.SetActive(true);
        }
    }
    public float getTimer() { return elapsedTime; }
    IEnumerator CountdownToStart()
    {
        countdownDisplay.fontSize = 400;
        while (countdownTime > 0)
        {
            countdownDisplay.text = countdownTime.ToString();
            yield return new WaitForSeconds(1f);
            countdownTime--;
        }

        countdownDisplay.text = "GO";
        elapsedTime = 0;
        timerGoing = true;
        StartCoroutine(UpdateTimer());
        DisplayRoundCount = -1;
        RaceStarted = true;
        yield return new WaitForSeconds(2f);
        countdownDisplay.gameObject.SetActive(false);
    }

    IEnumerator CountdownToHide()
    {
        yield return new WaitForSeconds(2f);
        countdownDisplay.gameObject.SetActive(false);
    }
    private IEnumerator UpdateTimer()
    {
        while (timerGoing)
        {
            elapsedTime += Time.deltaTime;
            timePlaying = TimeSpan.FromSeconds(elapsedTime);
            string timePlayingStr = timePlaying.ToString("m':'ss'.'fff");
            timeCounter.text = timePlayingStr;

            yield return null;
        }
    }
}

